<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if(!class_exists('\Twig\Environment')){
	require_once(__DIR__ . '/../../twig-vendor/autoload.php');
}

class Softlite_Dynamic_Button extends \Elementor\Widget_Base {

	public function get_name() {
		return 'softlite_dynamic_button';
	}

	public function get_title() {
		return esc_html__( 'Dynamic Button', 'softlite' );
	}

	public function get_icon() {
		return 'eicon-button';
	}

	public function get_categories() {
		return [ 'softlite' ];
	}

	public function get_keywords() {
		return [ 'button', 'softlite', 'dynamic' ];
	}

	public function get_style_depends() {
		return [ 
			'softlite-integration-widget-style'
		];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_button',
			[
				'label' => esc_html__( 'Button', 'elementor' ),
			]
		);

		$this->add_control(
			'button_text_enable',
			[
				'label' => esc_html__( 'Button Text Enable', 'elementor' ),
				'type' => Elementor\Controls_Manager::HIDDEN,
			]
		);

        $this->add_control(
			'text',
			[
				'label' => esc_html__( 'Text', 'elementor' ),
				'type' => Elementor\Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => esc_html__( 'Click here', 'elementor' ),
				'placeholder' => esc_html__( 'Click here', 'elementor' ),
				'condition' => [
					'button_text_enable' => '1',
				],
			]
		);

		$this->add_control(
			'link',
			[
				'label' => esc_html__( 'Link', 'elementor' ),
				'type' => Elementor\Controls_Manager::URL,
				'dynamic' => [
					'active' => true,
				],
				'default' => [
					'url' => '#',
				],
			]
		);

		$this->add_control(
			'selected_icon_enable',
			[
				'label' => esc_html__( 'Icon/Image Enable', 'elementor' ),
				'type' => Elementor\Controls_Manager::HIDDEN,
			]
		);

        $this->add_control(
			'selected_icon_source',
			[
				'label' => esc_html__( 'Icon Source', 'elementor' ),
				'type' => Elementor\Controls_Manager::SELECT,
				'options' => [
					'icon' => esc_html__( 'Icon library', 'elementor' ),
					'image' => esc_html__( 'Image', 'elementor' ),
				],
				'default' => 'icon',
				'condition' => [
					'selected_icon_enable' => '1',
				],
			]
		);

		$this->add_control(
			'selected_icon',
			[
				'label' => esc_html__( 'Icon', 'elementor' ),
				'type' => Elementor\Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'fa-solid',
				],
				'condition' => [
					'selected_icon_enable' => '1',
					'selected_icon_source' => 'icon',
				],
			]
		);

        $this->add_control(
			'selected_icon_image_source',
			[
				'label' => esc_html__( 'Image Source', 'elementor' ),
				'type' => Elementor\Controls_Manager::SELECT,
				'options' => [
					'upload' => esc_html__( 'Upload File', 'elementor' ),
					'external' => esc_html__( 'External URL', 'elementor' ),
				],
				'default' => 'upload',
                'condition' => [
					'selected_icon_enable' => '1',
					'selected_icon_source' => 'image',
				],
			]
		);

        $this->add_control(
            'selected_icon_image',
            [
                'label' => esc_html__( 'Image', 'elementor' ),
                'type' => Elementor\Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
					'selected_icon_enable' => '1',
                    'selected_icon_source' => 'image',
                    'selected_icon_image_source' => 'upload',
                ],
            ]
        );

        $this->add_control(
			'selected_icon_image_external_url' ,
			[
				'label' => esc_html__( 'Image URL', 'elementor' ),
				'type' => Elementor\Controls_Manager::TEXT,
				'ai' => [
					'active' => false,
				],
				'condition' => [
					'selected_icon_enable' => '1',
                    'selected_icon_source' => 'image',
					'selected_icon_image_source' => 'external',
				],
			]
		);

        $this->add_control(
			'button_css_id',
			[
				'label' => esc_html__( 'Button ID', 'elementor' ),
				'type' => Elementor\Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'ai' => [
					'active' => false,
				],
				'default' => '',
				'title' => esc_html__( 'Add your custom id WITHOUT the Pound key. e.g: my-id', 'elementor' ),
				'description' => sprintf(
					esc_html__( 'Please make sure the ID is unique and not used elsewhere on the page this form is displayed. This field allows %1$sA-z 0-9%2$s & underscore chars without spaces.', 'elementor' ),
					'<code>',
					'</code>'
				),
				'separator' => 'before',
			]
		);

        $this->add_control(
			'dynamic_template',
            [
                'label' => esc_html__( 'Dynamic Template', 'elementor' ),
                'type' => Elementor\Controls_Manager::HIDDEN,
                'language' => 'html',
                'rows' => 20,
                'default' => '<div class="softlite-dynamic-button-wrapper">{{settings.text}}</div>',
                'ai' => [
					'active' => false,
				],
			]
		);

		$this->end_controls_section();

        $this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Button', 'elementor' ),
				'tab' => Elementor\Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_group_control(
			Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'typography',
				'global' => [
					'default' => Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_ACCENT,
				],
				'selector' => '{{WRAPPER}} .softlite-dynamic-button .softlite-dynamic-button-text',
			]
		);

		$this->add_group_control(
			Elementor\Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'text_shadow',
				'selector' => '{{WRAPPER}} .softlite-dynamic-button .softlite-dynamic-button-text',
			]
		);

		$this->start_controls_tabs( 'tabs_button_style');

		$this->start_controls_tab(
			'tab_button_normal',
			[
				'label' => esc_html__( 'Normal', 'elementor' ),
			]
		);

		$this->add_control(
			'button_text_color',
			[
				'label' => esc_html__( 'Text Color', 'elementor' ),
				'type' => Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .softlite-dynamic-button .softlite-dynamic-button-text' => 'fill: {{VALUE}}; color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Icon Color', 'elementor' ),
				'type' => Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .softlite-dynamic-icon' => 'color: {{VALUE}};',
					'{{WRAPPER}} .softlite-dynamic-icon svg, {{WRAPPER}} .softlite-dynamic-icon svg path' => 'fill: {{VALUE}};',
				],
				'condition' => [
					'selected_icon_source' => 'icon',
				],
			]
		);

		$this->add_group_control(
			Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'types' => [ 'classic', 'gradient' ],
				'exclude' => [ 'image' ],
				'selector' => '{{WRAPPER}} .softlite-dynamic-button',
				'fields_options' => [
					'background' => [
						'default' => 'classic',
					],
					'color' => [
						'global' => [
							'default' => Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_ACCENT,
						],
					],
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => esc_html__( 'Hover', 'elementor' ),
			]
		);

		$this->add_control(
			'hover_color',
			[
				'label' => esc_html__( 'Text Color', 'elementor' ),
				'type' => Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .softlite-dynamic-button:hover .softlite-dynamic-button-text, {{WRAPPER}} .softlite-dynamic-button:focus .softlite-dynamic-button-text' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'hover_icon_color',
			[
				'label' => esc_html__( 'Icon Color', 'elementor' ),
				'type' => Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .softlite-dynamic-button:hover .softlite-dynamic-icon' => 'color: {{VALUE}};',
					'{{WRAPPER}} .softlite-dynamic-button:hover .softlite-dynamic-icon svg, {{WRAPPER}} .softlite-dynamic-button:hover .softlite-dynamic-icon svg path' => 'fill: {{VALUE}};',
				],
				'condition' => [
					'selected_icon_source' => 'icon',
				],
			]
		);

		$this->add_group_control(
			Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'button_background_hover',
				'types' => [ 'classic', 'gradient' ],
				'exclude' => [ 'image' ],
				'selector' => '{{WRAPPER}} .softlite-dynamic-button:hover, {{WRAPPER}} .softlite-dynamic-button:focus',
				'fields_options' => [
					'background' => [
						'default' => 'classic',
					],
				],
			]
		);

		$this->add_control(
			'button_hover_border_color',
			[
				'label' => esc_html__( 'Border Color', 'elementor' ),
				'type' => Elementor\Controls_Manager::COLOR,
				'condition' => [
					'border_border!' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .softlite-dynamic-button:hover, {{WRAPPER}} .softlite-dynamic-button:focus' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_hover_transition_duration',
			[
				'label' => esc_html__( 'Transition Duration', 'elementor' ),
				'type' => Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 's', 'ms', 'custom' ],
				'default' => [
					'unit' => 's',
				],
				'selectors' => [
					'{{WRAPPER}} .softlite-dynamic-button' => 'transition-duration: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'hover_animation',
			[
				'label' => esc_html__( 'Hover Animation', 'elementor' ),
				'type' => Elementor\Controls_Manager::HOVER_ANIMATION,
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_group_control(
			Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'border',
				'selector' => '{{WRAPPER}} .softlite-dynamic-button',
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'elementor' ),
				'type' => Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .softlite-dynamic-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'button_box_shadow',
				'selector' => '{{WRAPPER}} .softlite-dynamic-button',
			]
		);

		$this->add_responsive_control(
			'text_padding',
			[
				'label' => esc_html__( 'Padding', 'elementor' ),
				'type' => Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .softlite-dynamic-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);

        $this->end_controls_section();
	}

    public function dynamic_render($render) {
		ob_start();

		$settings = $this->get_settings_for_display();

        $render = str_replace('settings.', '', $render);
        
		foreach ($settings as $key => $setting) {
			${$key} = $setting;
		}

		try {
		    eval("?> $render <?php ");;
		} catch (ParseError $e) {
		    echo 'Dynamic Widget Debug: ' . $e->getMessage();
		}

		return ob_get_clean();
	}

	public function render_icon() {
		ob_start();

		$settings = $this->get_settings_for_display();

		$migration_allowed = Elementor\Icons_Manager::is_migration_allowed();

		if ( $settings['selected_icon_source'] === 'icon' ) {
			if (! empty( $settings['selected_icon']['value'] )) :
				?>
				<span class="softlite-dynamic-icon">
					<?php
						Elementor\Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] );
					?>
				</span>
			<?php endif;
		}

		return ob_get_clean();
	}

	protected function render(): void {
		$settings = $this->get_settings_for_display();

		if ( empty( $settings['dynamic_template'] ) ) {
			return;
		}

		$settings['icon_html'] = $this->render_icon();

        $loader = new \Twig\Loader\ArrayLoader([]);
        $twig = new \Twig\Environment($loader, [
            'debug' => true,
        ]);
        $twig->addExtension(new \Twig\Extension\DebugExtension());
        $render_template = $this->dynamic_render($settings['dynamic_template']);

        if (stripos($render_template, 'Dynamic Widget Debug') === false) {
            try {
                $twig->tokenize($settings['dynamic_template']);
                $template = $twig->createTemplate($render_template);
                echo $template->render($settings);
            } catch (\Twig_Error_Syntax $e) {
                $error_message = $e->getMessage();
                $error_message = explode('"', $error_message);

                echo '<pre>';
                echo 'Dynamic Widget Debug: ' . $error_message[0];
                echo '</pre>';
            }
        } else {
            echo '<pre>';
            echo $render_template;
            echo '</pre>';
        }
	}

	protected function content_template(): void {
		?>
		<#
            if ( '' === settings.dynamic_template ) {
                return;
            }
            
            function twigToTemplateLiteral(twigTemplate) {
				return twigTemplate
					// First handle if/else
					.replace(/{%\s*if\s+([^%]+)\s*%}((?:(?!{%\s*(?:if|endif|else)\s*%}).)*){%\s*else\s*%}((?:(?!{%\s*(?:if|endif)\s*%}).)*){%\s*endif\s*%}/g, '${$1 ? `$2` : `$3`}')
					// Then handle simple if
					.replace(/{%\s*if\s+([^%]+)\s*%}((?:(?!{%\s*(?:if|endif)\s*%}).)*){%\s*endif\s*%}/g, '${$1 ? `$2` : ``}')
					// Handle for loops
					.replace(/{%\s*for\s+(\w+)\s+in\s+([^\s%]+)\s*%}([\s\S]*?){%\s*endfor\s*%}/g, '${$2.map(($1) => `$3`).join(\'\')}')
					// Handle raw filter
					.replace(/\{\{\s*([^}]+?)\|raw\s*\}\}/g, '${$1}')
					// Handle regular variables
					.replace(/{{\s*([^}]+)\s*}}/g, '${$1}');
			}

            const iconHTML = elementor.helpers.renderIcon( view, settings.selected_icon, { 'aria-hidden': true }, 'i' , 'object' );
			settings.icon_html = iconHTML ? iconHTML.value : '';
            
            let templateHtml = '';

            try {
                const template = twigToTemplateLiteral(settings.dynamic_template).replace('|raw', '');
                templateHtml = new Function('settings', `return \`${template}\`;`)(settings);
            } catch (error) {
                templateHtml = 'Syntax Error: ' + error.message;
            }
		#>
            {{{ templateHtml }}}
		<?php
	}
}
