<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if(!class_exists('\Twig\Environment')){
	require_once(__DIR__ . '/../../twig-vendor/autoload.php');
}

class Softlite_Dynamic_Card_Box extends \Elementor\Widget_Base {

	public function get_name() {
		return 'softlite_dynamic_card_box';
	}

	public function get_title() {
		return esc_html__( 'Dynamic Card Box', 'softlite' );
	}

	public function get_icon() {
		return 'eicon-image-box';
	}

	public function get_categories() {
		return [ 'softlite' ];
	}

	public function get_keywords() {
		return [ 'card box', 'icon box', 'image box', 'softlite', 'dynamic' ];
	}

	public function get_style_depends() {
		return [ 
			'softlite-integration-widget-style'
		];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_card_box',
            [
                'label' => esc_html__( 'Card Box', 'elementor' ),
            ]
		);

        $this->add_control(
			'selected_icon_enable',
			[
				'label' => esc_html__( 'Icon/Image Enable', 'elementor' ),
				'type' => Elementor\Controls_Manager::HIDDEN,
			]
		);

        $this->add_control(
			'selected_icon_source',
			[
				'label' => esc_html__( 'Icon/Image Source', 'elementor' ),
				'type' => Elementor\Controls_Manager::SELECT,
				'options' => [
					'icon' => esc_html__( 'Icon library', 'elementor' ),
					'image' => esc_html__( 'Image', 'elementor' ),
				],
				'default' => 'icon',
                'condition' => [
					'selected_icon_enable' => '1',
				],
			]
		);

		$this->add_control(
			'selected_icon',
			[
				'label' => esc_html__( 'Icon', 'elementor' ),
				'type' => Elementor\Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'fa-solid',
				],
				'condition' => [
					'selected_icon_enable' => '1',
					'selected_icon_source' => 'icon',
				],
			]
		);

        $this->add_control(
			'selected_icon_image_source',
			[
				'label' => esc_html__( 'Image Source', 'elementor' ),
				'type' => Elementor\Controls_Manager::SELECT,
				'options' => [
					'upload' => esc_html__( 'Upload File', 'elementor' ),
					'external' => esc_html__( 'External URL', 'elementor' ),
				],
				'default' => 'upload',
                'condition' => [
					'selected_icon_enable' => '1',
					'selected_icon_source' => 'image',
				],
			]
		);

        $this->add_control(
            'selected_icon_image',
            [
                'label' => esc_html__( 'Image', 'elementor' ),
                'type' => Elementor\Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
					'selected_icon_enable' => '1',
                    'selected_icon_source' => 'image',
                    'selected_icon_image_source' => 'upload',
                ],
            ]
        );

        $this->add_control(
			'selected_icon_image_external_url' ,
			[
				'label' => esc_html__( 'Image URL', 'elementor' ),
				'type' => Elementor\Controls_Manager::TEXT,
				'ai' => [
					'active' => false,
				],
				'condition' => [
					'selected_icon_enable' => '1',
                    'selected_icon_source' => 'image',
					'selected_icon_image_source' => 'external',
				],
			]
		);

		$this->add_control(
			'text_1_enable',
			[
				'label' => esc_html__( 'Text 1 Enable', 'elementor' ),
				'type' => Elementor\Controls_Manager::HIDDEN,
			]
		);

        $this->add_control(
			'text_1',
			[
				'label' => esc_html__( 'Text 1', 'elementor' ),
                'label_block' => true,
				'type' => Elementor\Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'condition' => [
					'text_1_enable' => '1',
				],
			]
		);

        // $this->add_control(
		// 	'text_1_tag',
		// 	[
		// 		'label' => esc_html__( 'Text 1 Tag', 'elementor' ),
		// 		'type' => Elementor\Controls_Manager::TEXT,
		// 		'dynamic' => [
		// 			'active' => true,
		// 		],
		// 	]
		// );

		$this->add_control(
			'text_2_enable',
			[
				'label' => esc_html__( 'Text 2 Enable', 'elementor' ),
				'type' => Elementor\Controls_Manager::HIDDEN,
			]
		);

        $this->add_control(
			'text_2',
			[
				'label' => esc_html__( 'Text 2', 'elementor' ),
                'label_block' => true,
				'type' => Elementor\Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'condition' => [
					'text_2_enable' => '1',
				],
			]
		);

        // $this->add_control(
		// 	'text_2_tag',
		// 	[
		// 		'label' => esc_html__( 'Text 2 Tag', 'elementor' ),
		// 		'type' => Elementor\Controls_Manager::TEXT,
		// 		'dynamic' => [
		// 			'active' => true,
		// 		],
		// 	]
		// );

		$this->add_control(
			'text_3_enable',
			[
				'label' => esc_html__( 'Text 3 Enable', 'elementor' ),
				'type' => Elementor\Controls_Manager::HIDDEN,
			]
		);

        $this->add_control(
			'text_3',
			[
				'label' => esc_html__( 'Text 3', 'elementor' ),
                'label_block' => true,
				'type' => Elementor\Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'condition' => [
					'text_3_enable' => '1',
				],
			]
		);

        // $this->add_control(
		// 	'text_3_tag',
		// 	[
		// 		'label' => esc_html__( 'Text 3 Tag', 'elementor' ),
		// 		'type' => Elementor\Controls_Manager::TEXT,
		// 		'dynamic' => [
		// 			'active' => true,
		// 		],
		// 	]
		// );

		$this->add_control(
			'button_text_enable',
			[
				'label' => esc_html__( 'Button Text Enable', 'elementor' ),
				'type' => Elementor\Controls_Manager::HIDDEN,
			]
		);

        $this->add_control(
			'button_text',
			[
				'label' => esc_html__( 'Button Text', 'elementor' ),
                'label_block' => true,
				'type' => Elementor\Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'condition' => [
					'button_text_enable' => '1',
				],
			]
		);

		$this->add_control(
			'link',
			[
				'label' => esc_html__( 'Link', 'elementor' ),
				'type' => Elementor\Controls_Manager::URL,
				'dynamic' => [
					'active' => true,
				],
				'default' => [
					'url' => '#',
				],
			]
		);

        $this->add_control(
			'dynamic_template',
            [
                'label' => esc_html__( 'Dynamic Template', 'elementor' ),
                'type' => Elementor\Controls_Manager::HIDDEN,
                'language' => 'html',
                'rows' => 20,
                'default' => '<div class="softlite-dynamic-button-wrapper">{{settings.text}}</div>',
                'ai' => [
					'active' => false,
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_icon_style',
			[
				'label' => esc_html__( 'Icon/Image', 'elementor' ),
				'tab' => Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'icon_size',
			[
				'label' => esc_html__( 'Size', 'elementor' ),
				'type' => Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
				'default' => [
					'size' => 100,
					'unit' => '%',
				],
				'range' => [
					'px' => [
						'min' => 6,
						'max' => 1000,
					],
					'%' => [
						'min' => 6,
					],
					'vw' => [
						'min' => 6,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .softlite-dynamic-icon' => 'font-size: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .softlite-dynamic-icon svg' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->start_controls_tabs( 'icon_colors' );

		$this->start_controls_tab(
			'icon_colors_normal',
			[
				'label' => esc_html__( 'Normal', 'elementor' ),
			]
		);

		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Color', 'elementor' ),
				'type' => Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .softlite-dynamic-icon i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .softlite-dynamic-icon svg' => 'fill: {{VALUE}};',
				],
				'global' => [
					'default' => Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_PRIMARY,
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'icon_colors_hover',
			[
				'label' => esc_html__( 'Hover', 'elementor' ),
			]
		);

		$this->add_control(
			'icon_color_hover',
			[
				'label' => esc_html__( 'Color', 'elementor' ),
				'type' => Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .softlite-dynamic-card-box:hover .softlite-dynamic-icon i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .softlite-dynamic-card-box:hover .softlite-dynamic-icon svg' => 'fill: {{VALUE}};',
				],
			]
		);

		// $this->add_control(
		// 	'icon_color_hover_transition',
		// 	[
		// 		'label' => esc_html__( 'Transition Duration', 'elementor' ),
		// 		'type' => Elementor\Controls_Manager::SLIDER,
		// 		'size_units' => [ 's', 'ms', 'custom' ],
		// 		'default' => [
		// 			'unit' => 's',
		// 			'size' => 0.3,
		// 		],
		// 		'selectors' => [
		// 			'{{WRAPPER}} .softlite-dynamic-list-icon i' => 'transition: color {{SIZE}}{{UNIT}}',
		// 			'{{WRAPPER}} .softlite-dynamic-list-icon svg' => 'transition: fill {{SIZE}}{{UNIT}}',
		// 		],
		// 	]
		// );

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

		$this->start_controls_section(
			'section_text_style',
			[
				'label' => esc_html__( 'Text', 'elementor' ),
				'tab' => Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'text_1_typography',
				'label' => esc_html__( 'Text 1 Typography', 'elementor' ),
				'selector' => '{{WRAPPER}} .softlite-dynamic-card-box-text-1',
				'global' => [
					'default' => Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_TEXT,
				],
			]
		);

		$this->add_group_control(
			Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'text_2_typography',
				'label' => esc_html__( 'Text 2 Typography', 'elementor' ),
				'selector' => '{{WRAPPER}} .softlite-dynamic-card-box-text-2',
				'global' => [
					'default' => Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_TEXT,
				],
			]
		);

		$this->add_group_control(
			Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'text_3_typography',
				'label' => esc_html__( 'Text 3 Typography', 'elementor' ),
				'selector' => '{{WRAPPER}} .softlite-dynamic-card-box-text-3',
				'global' => [
					'default' => Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_TEXT,
				],
			]
		);

		$this->start_controls_tabs( 'text_colors' );

		$this->start_controls_tab(
			'text_colors_normal',
			[
				'label' => esc_html__( 'Normal', 'elementor' ),
			]
		);

		$this->add_control(
			'text_1_color',
			[
				'label' => esc_html__( 'Text 1 Color', 'elementor' ),
				'type' => Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .softlite-dynamic-card-box-text-1' => 'color: {{VALUE}};',
				],
				'global' => [
					'default' => Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_SECONDARY,
				],
			]
		);

		$this->add_control(
			'text_2_color',
			[
				'label' => esc_html__( 'Text 2 Color', 'elementor' ),
				'type' => Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .softlite-dynamic-card-box-text-2' => 'color: {{VALUE}};',
				],
				'global' => [
					'default' => Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_SECONDARY,
				],
			]
		);

		$this->add_control(
			'text_3_color',
			[
				'label' => esc_html__( 'Text 3 Color', 'elementor' ),
				'type' => Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .softlite-dynamic-card-box-text-3' => 'color: {{VALUE}};',
				],
				'global' => [
					'default' => Elementor\Core\Kits\Documents\Tabs\Global_Colors::COLOR_SECONDARY,
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'text_colors_hover',
			[
				'label' => esc_html__( 'Hover', 'elementor' ),
			]
		);

		$this->add_control(
			'text_1_color_hover',
			[
				'label' => esc_html__( 'Text 1 Color', 'elementor' ),
				'type' => Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .softlite-dynamic-card-box:hover .softlite-dynamic-card-box-text-1' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'text_2_color_hover',
			[
				'label' => esc_html__( 'Text 2 Color', 'elementor' ),
				'type' => Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .softlite-dynamic-card-box:hover .softlite-dynamic-card-box-text-2' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'text_3_color_hover',
			[
				'label' => esc_html__( 'Text 3 Color', 'elementor' ),
				'type' => Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .softlite-dynamic-card-box:hover .softlite-dynamic-card-box-text-3' => 'color: {{VALUE}};',
				],
			]
		);

		// $this->add_control(
		// 	'text_color_hover_transition',
		// 	[
		// 		'label' => esc_html__( 'Transition Duration', 'elementor' ),
		// 		'type' => Elementor\Controls_Manager::SLIDER,
		// 		'size_units' => [ 's', 'ms', 'custom' ],
		// 		'default' => [
		// 			'unit' => 's',
		// 			'size' => 0.3,
		// 		],
		// 		'selectors' => [
		// 			'{{WRAPPER}} .softlite-dynamic-list-text' => 'transition: color {{SIZE}}{{UNIT}}',
		// 		],
		// 	]
		// );

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

		$this->start_controls_section(
			'section_button_style',
			[
				'label' => esc_html__( 'Button', 'elementor' ),
				'tab' => Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'button_text_typography',
				'label' => esc_html__( 'Button Text Typography', 'elementor' ),
				'global' => [
					'default' => Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_ACCENT,
				],
				'selector' => '{{WRAPPER}} .softlite-dynamic-card-box-button-text',
			]
		);

		$this->start_controls_tabs( 'tabs_button_style');

		$this->start_controls_tab(
			'tab_button_normal',
			[
				'label' => esc_html__( 'Normal', 'elementor' ),
			]
		);

		$this->add_control(
			'button_text_color',
			[
				'label' => esc_html__( 'Button Text Color', 'elementor' ),
				'type' => Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .softlite-dynamic-card-box-button-text' => 'fill: {{VALUE}}; color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_background_color',
			[
				'label' => esc_html__( 'Button Background Color', 'elementor' ),
				'type' => Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .softlite-dynamic-card-box-button' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => esc_html__( 'Hover', 'elementor' ),
			]
		);

		$this->add_control(
			'button_text_color_hover',
			[
				'label' => esc_html__( 'Button Text Color', 'elementor' ),
				'type' => Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .softlite-dynamic-card-box:hover .softlite-dynamic-card-box-button-text, {{WRAPPER}} .softlite-dynamic-card-box:focus .softlite-dynamic-card-box-button-text' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_background_color_hover',
			[
				'label' => esc_html__( 'Button Background Color', 'elementor' ),
				'type' => Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .softlite-dynamic-card-box:hover .softlite-dynamic-card-box-button, {{WRAPPER}} .softlite-dynamic-card-box:focus .softlite-dynamic-card-box-button' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();
	}

    public function dynamic_render($render) {
		ob_start();

		$settings = $this->get_settings_for_display();

        $render = str_replace('settings.', '', $render);
        
		foreach ($settings as $key => $setting) {
			${$key} = $setting;
		}

		try {
		    eval("?> $render <?php ");;
		} catch (ParseError $e) {
		    echo 'Dynamic Widget Debug: ' . $e->getMessage();
		}

		return ob_get_clean();
	}

	public function render_icon() {
		ob_start();

		$settings = $this->get_settings_for_display();

		$migration_allowed = Elementor\Icons_Manager::is_migration_allowed();

		if ( $settings['selected_icon_source'] === 'icon' ) {
			if (! empty( $settings['selected_icon']['value'] )) :
				?>
				<span class="softlite-dynamic-icon">
					<?php
						Elementor\Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] );
					?>
				</span>
			<?php endif;
		}

		return ob_get_clean();
	}

	protected function render(): void {
		$settings = $this->get_settings_for_display();

		if ( empty( $settings['dynamic_template'] ) ) {
			return;
		}

		$settings['icon_html'] = $this->render_icon();

        $loader = new \Twig\Loader\ArrayLoader([]);
        $twig = new \Twig\Environment($loader, [
            'debug' => true,
        ]);
        $twig->addExtension(new \Twig\Extension\DebugExtension());
        $render_template = $this->dynamic_render($settings['dynamic_template']);

        if (stripos($render_template, 'Dynamic Widget Debug') === false) {
            try {
                $twig->tokenize($settings['dynamic_template']);
                $template = $twig->createTemplate($render_template);
                echo $template->render($settings);
            } catch (\Twig_Error_Syntax $e) {
                $error_message = $e->getMessage();
                $error_message = explode('"', $error_message);

                echo '<pre>';
                echo 'Dynamic Widget Debug: ' . $error_message[0];
                echo '</pre>';
            }
        } else {
            echo '<pre>';
            echo $render_template;
            echo '</pre>';
        }
	}

	protected function content_template(): void {
		?>
		<#
            if ( '' === settings.dynamic_template ) {
                return;
            }
            
            function twigToTemplateLiteral(twigTemplate) {
				return twigTemplate
					// First handle if/else
					.replace(/{%\s*if\s+([^%]+)\s*%}((?:(?!{%\s*(?:if|endif|else)\s*%}).)*){%\s*else\s*%}((?:(?!{%\s*(?:if|endif)\s*%}).)*){%\s*endif\s*%}/g, '${$1 ? `$2` : `$3`}')
					// Then handle simple if
					.replace(/{%\s*if\s+([^%]+)\s*%}((?:(?!{%\s*(?:if|endif)\s*%}).)*){%\s*endif\s*%}/g, '${$1 ? `$2` : ``}')
					// Handle for loops
					.replace(/{%\s*for\s+(\w+)\s+in\s+([^\s%]+)\s*%}([\s\S]*?){%\s*endfor\s*%}/g, '${$2.map(($1) => `$3`).join(\'\')}')
					// Handle raw filter
					.replace(/\{\{\s*([^}]+?)\|raw\s*\}\}/g, '${$1}')
					// Handle regular variables
					.replace(/{{\s*([^}]+)\s*}}/g, '${$1}');
			}

            const iconHTML = elementor.helpers.renderIcon( view, settings.selected_icon, { 'aria-hidden': true }, 'i' , 'object' );
			settings.icon_html = iconHTML ? iconHTML.value : '';
            
            let templateHtml = '';

            try {
                const template = twigToTemplateLiteral(settings.dynamic_template).replace('|raw', '');
                templateHtml = new Function('settings', `return \`${template}\`;`)(settings);
            } catch (error) {
                templateHtml = 'Syntax Error: ' + error.message;
            }
		#>
            {{{ templateHtml }}}
		<?php
	}
}
